/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.channels;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CancellableContinuationImplKt;
import kotlinx.coroutines.DebugKt;
import kotlinx.coroutines.channels.AbstractChannel;
import kotlinx.coroutines.channels.AbstractChannelKt;
import kotlinx.coroutines.channels.AbstractSendChannel;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.channels.Closed;
import kotlinx.coroutines.channels.Receive;
import kotlinx.coroutines.channels.ReceiveOrClosed;
import kotlinx.coroutines.channels.Send;
import kotlinx.coroutines.internal.AtomicKt;
import kotlinx.coroutines.internal.OnUndeliveredElementKt;
import kotlinx.coroutines.internal.Symbol;
import kotlinx.coroutines.internal.UndeliveredElementException;
import kotlinx.coroutines.selects.SelectInstance;
import kotlinx.coroutines.selects.SelectKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\b\u0010\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000BB9\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012 \u0010\t\u001a\u001c\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00028\u0000\u0018\u0001`\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0013\u001a\u00020\u00122\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0014\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0019\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0016\u001a\u00020\u0015H\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001a\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001c\u001a\u00020\u00172\u0006\u0010\r\u001a\u00028\u0000H\u0014\u00a2\u0006\u0004\b\u001c\u0010\u001dJ#\u0010 \u001a\u00020\u00172\u0006\u0010\r\u001a\u00028\u00002\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0014\u00a2\u0006\u0004\b \u0010!J\u0017\u0010#\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0012H\u0014\u00a2\u0006\u0004\b#\u0010$J\u0011\u0010%\u001a\u0004\u0018\u00010\u0017H\u0014\u00a2\u0006\u0004\b%\u0010&J\u001d\u0010'\u001a\u0004\u0018\u00010\u00172\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0014\u00a2\u0006\u0004\b'\u0010(J\u0019\u0010*\u001a\u0004\u0018\u00010)2\u0006\u0010\f\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b*\u0010+R\u001e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170,8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0016\u00102\u001a\u00020/8T@\u0014X\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0016\u0010\u0003\u001a\u00020\u00028\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00103R\u0016\u00104\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b4\u00103R\u0016\u00105\u001a\u00020\u00128D@\u0004X\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0016\u00107\u001a\u00020\u00128D@\u0004X\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00106R\u0016\u00108\u001a\u00020\u00128D@\u0004X\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00106R\u0016\u00109\u001a\u00020\u00128D@\u0004X\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u00106R\u0016\u0010:\u001a\u00020\u00128V@\u0016X\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u00106R\u0016\u0010;\u001a\u00020\u00128V@\u0016X\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u00106R\u001a\u0010>\u001a\u00060<j\u0002`=8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u0016\u0010\u0005\u001a\u00020\u00048\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010@\u00a8\u0006A"}, d2={"Lkotlinx/coroutines/channels/ArrayChannel;", "E", "", "capacity", "Lkotlinx/coroutines/channels/BufferOverflow;", "onBufferOverflow", "Lkotlin/Function1;", "", "Lkotlinx/coroutines/internal/OnUndeliveredElement;", "onUndeliveredElement", "<init>", "(ILkotlinx/coroutines/channels/BufferOverflow;Lkotlin/jvm/functions/Function1;)V", "currentSize", "element", "enqueueElement", "(ILjava/lang/Object;)V", "Lkotlinx/coroutines/channels/Receive;", "receive", "", "enqueueReceiveInternal", "(Lkotlinx/coroutines/channels/Receive;)Z", "Lkotlinx/coroutines/channels/Send;", "send", "", "enqueueSend", "(Lkotlinx/coroutines/channels/Send;)Ljava/lang/Object;", "ensureCapacity", "(I)V", "offerInternal", "(Ljava/lang/Object;)Ljava/lang/Object;", "Lkotlinx/coroutines/selects/SelectInstance;", "select", "offerSelectInternal", "(Ljava/lang/Object;Lkotlinx/coroutines/selects/SelectInstance;)Ljava/lang/Object;", "wasClosed", "onCancelIdempotent", "(Z)V", "pollInternal", "()Ljava/lang/Object;", "pollSelectInternal", "(Lkotlinx/coroutines/selects/SelectInstance;)Ljava/lang/Object;", "Lkotlinx/coroutines/internal/Symbol;", "updateBufferSize", "(I)Lkotlinx/coroutines/internal/Symbol;", "", "buffer", "[Ljava/lang/Object;", "", "getBufferDebugString", "()Ljava/lang/String;", "bufferDebugString", "I", "head", "isBufferAlwaysEmpty", "()Z", "isBufferAlwaysFull", "isBufferEmpty", "isBufferFull", "isClosedForReceive", "isEmpty", "Ljava/util/concurrent/locks/ReentrantLock;", "Lkotlinx/coroutines/internal/ReentrantLock;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "Lkotlinx/coroutines/channels/BufferOverflow;", "kotlinx-coroutines-core", "Lkotlinx/coroutines/channels/AbstractChannel;"})
public class ArrayChannel<E>
extends AbstractChannel<E> {
    private final int capacity;
    @NotNull
    private final BufferOverflow onBufferOverflow;
    @NotNull
    private final ReentrantLock lock;
    @NotNull
    private Object[] buffer;
    private int head;
    @NotNull
    private volatile /* synthetic */ int size;

    /*
     * WARNING - void declaration
     */
    public ArrayChannel(int capacity, @NotNull BufferOverflow onBufferOverflow, @Nullable Function1<? super E, Unit> onUndeliveredElement) {
        super(onUndeliveredElement);
        void $this$buffer_u24lambda_u2d1;
        this.capacity = capacity;
        this.onBufferOverflow = onBufferOverflow;
        int n = this.capacity >= 1 ? 1 : 0;
        int n2 = 0;
        boolean bl = false;
        if (n == 0) {
            boolean bl2 = false;
            String string = "ArrayChannel capacity must be at least 1, but " + this.capacity + " was specified";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.lock = new ReentrantLock();
        n = this.capacity;
        n2 = 8;
        bl = false;
        Object[] objectArray = new Object[Math.min(n, n2)];
        n2 = 0;
        bl = false;
        Object[] bl2 = objectArray;
        ArrayChannel arrayChannel = this;
        boolean bl3 = false;
        ArraysKt.fill$default((Object[])$this$buffer_u24lambda_u2d1, AbstractChannelKt.EMPTY, 0, 0, 6, null);
        Unit unit = Unit.INSTANCE;
        arrayChannel.buffer = objectArray;
        this.size = 0;
    }

    @Override
    protected final boolean isBufferAlwaysEmpty() {
        return false;
    }

    @Override
    protected final boolean isBufferEmpty() {
        return this.size == 0;
    }

    @Override
    protected final boolean isBufferAlwaysFull() {
        return false;
    }

    @Override
    protected final boolean isBufferFull() {
        return this.size == this.capacity && this.onBufferOverflow == BufferOverflow.SUSPEND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        ReentrantLock $this$withLock$iv = this.lock;
        boolean $i$f$withLock = false;
        Lock lock = $this$withLock$iv;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            bl2 = this.isEmptyImpl();
        }
        finally {
            lock.unlock();
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosedForReceive() {
        ReentrantLock $this$withLock$iv = this.lock;
        boolean $i$f$withLock = false;
        Lock lock = $this$withLock$iv;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            bl2 = super.isClosedForReceive();
        }
        finally {
            lock.unlock();
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected Object offerInternal(E element) {
        ReceiveOrClosed<E> receive = null;
        ReentrantLock $this$withLock$iv = this.lock;
        boolean $i$f$withLock = false;
        Lock lock = $this$withLock$iv;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            int size = this.size;
            ReceiveOrClosed<E> receiveOrClosed = this.getClosedForSend();
            if (receiveOrClosed != null) {
                Closed<?> closed = receiveOrClosed;
                boolean bl4 = false;
                boolean bl5 = false;
                Closed<?> it = closed;
                boolean bl6 = false;
                Closed<?> closed2 = it;
                return closed2;
            }
            receiveOrClosed = this.updateBufferSize(size);
            if (receiveOrClosed != null) {
                ReceiveOrClosed<E> receiveOrClosed2 = receiveOrClosed;
                boolean bl7 = false;
                boolean bl8 = false;
                ReceiveOrClosed<E> it = receiveOrClosed2;
                boolean bl9 = false;
                ReceiveOrClosed<E> receiveOrClosed3 = it;
                return receiveOrClosed3;
            }
            if (size == 0) {
                while ((receiveOrClosed = this.takeFirstReceiveOrPeekClosed()) != null) {
                    receive = receiveOrClosed;
                    if (receive instanceof Closed) {
                        this.size = size;
                        ReceiveOrClosed<E> receiveOrClosed4 = receive;
                        return receiveOrClosed4;
                    }
                    Symbol token = receive.tryResumeReceive(element, null);
                    if (token == null) continue;
                    boolean bl10 = false;
                    if (DebugKt.getASSERTIONS_ENABLED()) {
                        boolean bl11 = false;
                        if (!(token == CancellableContinuationImplKt.RESUME_TOKEN)) {
                            throw new AssertionError();
                        }
                    }
                    break;
                }
            } else {
                this.enqueueElement(size, element);
                Symbol symbol = AbstractChannelKt.OFFER_SUCCESS;
                return symbol;
            }
            this.size = size;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        receive.completeResumeReceive(element);
        return receive.getOfferResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected Object offerSelectInternal(E element, @NotNull SelectInstance<?> select) {
        Object receive = null;
        ReentrantLock $this$withLock$iv = this.lock;
        boolean $i$f$withLock = false;
        Lock lock = $this$withLock$iv;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            AbstractSendChannel.TryOfferDesc<E> offerOp;
            int size;
            block14: {
                block15: {
                    boolean bl3 = false;
                    size = this.size;
                    Object object = this.getClosedForSend();
                    if (object != null) {
                        Closed<?> closed = object;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        Closed<?> it = closed;
                        boolean bl6 = false;
                        Closed<?> closed2 = it;
                        return closed2;
                    }
                    object = this.updateBufferSize(size);
                    if (object != null) {
                        Object object2 = object;
                        boolean bl7 = false;
                        boolean bl8 = false;
                        Object it = object2;
                        boolean bl9 = false;
                        Object object3 = it;
                        return object3;
                    }
                    if (size == 0) {
                        Object failure;
                        do {
                            offerOp = this.describeTryOffer(element);
                            failure = select.performAtomicTrySelect(offerOp);
                            if (failure == null) break block14;
                            if (failure == AbstractChannelKt.OFFER_FAILED) break block15;
                        } while (failure == AtomicKt.RETRY_ATOMIC);
                        if (failure == SelectKt.getALREADY_SELECTED() || failure instanceof Closed) {
                            this.size = size;
                            Object object4 = failure;
                            return object4;
                        }
                        String string = Intrinsics.stringPlus("performAtomicTrySelect(describeTryOffer) returned ", failure);
                        boolean bl10 = false;
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                }
                if (!select.trySelect()) {
                    this.size = size;
                    Object object = SelectKt.getALREADY_SELECTED();
                    return object;
                }
                this.enqueueElement(size, element);
                Symbol symbol = AbstractChannelKt.OFFER_SUCCESS;
                return symbol;
            }
            this.size = size;
            receive = offerOp.getResult();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        Object v0 = receive;
        Intrinsics.checkNotNull(v0);
        ((ReceiveOrClosed)v0).completeResumeReceive(element);
        return ((ReceiveOrClosed)receive).getOfferResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected Object enqueueSend(@NotNull Send send) {
        Object object;
        ReentrantLock $this$withLock$iv = this.lock;
        boolean $i$f$withLock = false;
        Lock lock = $this$withLock$iv;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            object = super.enqueueSend(send);
        }
        finally {
            lock.unlock();
        }
        return object;
    }

    private final Symbol updateBufferSize(int currentSize) {
        Symbol symbol;
        if (currentSize < this.capacity) {
            this.size = currentSize + 1;
            return null;
        }
        BufferOverflow bufferOverflow = this.onBufferOverflow;
        int n = WhenMappings.$EnumSwitchMapping$0[bufferOverflow.ordinal()];
        switch (n) {
            case 1: {
                symbol = AbstractChannelKt.OFFER_FAILED;
                break;
            }
            case 2: {
                symbol = AbstractChannelKt.OFFER_SUCCESS;
                break;
            }
            case 3: {
                symbol = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return symbol;
    }

    private final void enqueueElement(int currentSize, E element) {
        if (currentSize < this.capacity) {
            this.ensureCapacity(currentSize);
            this.buffer[(this.head + currentSize) % this.buffer.length] = element;
        } else {
            boolean bl = false;
            if (DebugKt.getASSERTIONS_ENABLED()) {
                boolean bl2 = false;
                if (!(this.onBufferOverflow == BufferOverflow.DROP_OLDEST)) {
                    throw new AssertionError();
                }
            }
            this.buffer[this.head % this.buffer.length] = null;
            this.buffer[(this.head + currentSize) % this.buffer.length] = element;
            this.head = (this.head + 1) % this.buffer.length;
        }
    }

    private final void ensureCapacity(int currentSize) {
        if (currentSize >= this.buffer.length) {
            int n = this.buffer.length * 2;
            int n2 = this.capacity;
            boolean bl = false;
            int newSize = Math.min(n, n2);
            Object[] newBuffer = new Object[newSize];
            n2 = 0;
            if (n2 < currentSize) {
                do {
                    int i = n2++;
                    newBuffer[i] = this.buffer[(this.head + i) % this.buffer.length];
                } while (n2 < currentSize);
            }
            ArraysKt.fill(newBuffer, AbstractChannelKt.EMPTY, currentSize, newSize);
            this.buffer = newBuffer;
            this.head = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected Object pollInternal() {
        Send send = null;
        boolean resumed = false;
        Object result2 = null;
        ReentrantLock $this$withLock$iv = this.lock;
        boolean $i$f$withLock = false;
        Lock lock = $this$withLock$iv;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            int size = this.size;
            if (size == 0) {
                Closed<?> closed = this.getClosedForSend();
                Object object = closed == null ? AbstractChannelKt.POLL_FAILED : closed;
                return object;
            }
            result2 = this.buffer[this.head];
            this.buffer[this.head] = null;
            this.size = size - 1;
            Object replacement = AbstractChannelKt.POLL_FAILED;
            if (size == this.capacity) {
                Send send2;
                while ((send2 = this.takeFirstSendOrPeekClosed()) != null) {
                    send = send2;
                    Symbol token = send.tryResumeSend(null);
                    if (token != null) {
                        boolean bl4 = false;
                        if (DebugKt.getASSERTIONS_ENABLED()) {
                            boolean bl5 = false;
                            if (!(token == CancellableContinuationImplKt.RESUME_TOKEN)) {
                                throw new AssertionError();
                            }
                        }
                        resumed = true;
                        replacement = send.getPollResult();
                        break;
                    }
                    send.undeliveredElement();
                }
            }
            if (replacement != AbstractChannelKt.POLL_FAILED && !(replacement instanceof Closed)) {
                this.size = size;
                this.buffer[(this.head + size) % this.buffer.length] = replacement;
            }
            this.head = (this.head + 1) % this.buffer.length;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        if (resumed) {
            Send send3 = send;
            Intrinsics.checkNotNull(send3);
            send3.completeResumeSend();
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected Object pollSelectInternal(@NotNull SelectInstance<?> select) {
        Object send = null;
        boolean success = false;
        Object result2 = null;
        ReentrantLock $this$withLock$iv = this.lock;
        boolean $i$f$withLock = false;
        Lock lock = $this$withLock$iv;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            Object replacement;
            int size;
            block17: {
                boolean bl3 = false;
                size = this.size;
                if (size == 0) {
                    Closed<?> closed = this.getClosedForSend();
                    Object object = closed == null ? AbstractChannelKt.POLL_FAILED : closed;
                    return object;
                }
                result2 = this.buffer[this.head];
                this.buffer[this.head] = null;
                this.size = size - 1;
                replacement = AbstractChannelKt.POLL_FAILED;
                if (size == this.capacity) {
                    Object failure;
                    do {
                        AbstractChannel.TryPollDesc pollOp = this.describeTryPoll();
                        failure = select.performAtomicTrySelect(pollOp);
                        if (failure == null) {
                            send = pollOp.getResult();
                            success = true;
                            Object object = send;
                            Intrinsics.checkNotNull(object);
                            replacement = ((Send)object).getPollResult();
                            break block17;
                        }
                        if (failure == AbstractChannelKt.POLL_FAILED) break block17;
                    } while (failure == AtomicKt.RETRY_ATOMIC);
                    if (failure == SelectKt.getALREADY_SELECTED()) {
                        this.size = size;
                        this.buffer[this.head] = result2;
                        Object object = failure;
                        return object;
                    }
                    if (failure instanceof Closed) {
                        send = failure;
                        success = true;
                        replacement = failure;
                    } else {
                        String string = Intrinsics.stringPlus("performAtomicTrySelect(describeTryOffer) returned ", failure);
                        boolean bl4 = false;
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                }
            }
            if (replacement != AbstractChannelKt.POLL_FAILED && !(replacement instanceof Closed)) {
                this.size = size;
                this.buffer[(this.head + size) % this.buffer.length] = replacement;
            } else if (!select.trySelect()) {
                this.size = size;
                this.buffer[this.head] = result2;
                Object object = SelectKt.getALREADY_SELECTED();
                return object;
            }
            this.head = (this.head + 1) % this.buffer.length;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        if (success) {
            Object object = send;
            Intrinsics.checkNotNull(object);
            ((Send)object).completeResumeSend();
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean enqueueReceiveInternal(@NotNull Receive<? super E> receive) {
        ReentrantLock $this$withLock$iv = this.lock;
        boolean $i$f$withLock = false;
        Lock lock = $this$withLock$iv;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            bl2 = super.enqueueReceiveInternal(receive);
        }
        finally {
            lock.unlock();
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onCancelIdempotent(boolean wasClosed) {
        Function1 onUndeliveredElement = this.onUndeliveredElement;
        UndeliveredElementException undeliveredElementException = null;
        ReentrantLock $this$withLock$iv = this.lock;
        boolean $i$f$withLock = false;
        Lock lock = $this$withLock$iv;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            int n = this.size;
            boolean bl4 = false;
            int n2 = 0;
            int n3 = n;
            for (n2 = 0; n2 < n3; ++n2) {
                int it = n2;
                boolean bl5 = false;
                Object value = this.buffer[this.head];
                if (onUndeliveredElement != null && value != AbstractChannelKt.EMPTY) {
                    undeliveredElementException = OnUndeliveredElementKt.callUndeliveredElementCatchingException(onUndeliveredElement, value, undeliveredElementException);
                }
                this.buffer[this.head] = AbstractChannelKt.EMPTY;
                this.head = (this.head + 1) % this.buffer.length;
            }
            this.size = 0;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        super.onCancelIdempotent(wasClosed);
        UndeliveredElementException undeliveredElementException2 = undeliveredElementException;
        if (undeliveredElementException2 != null) {
            UndeliveredElementException undeliveredElementException3 = undeliveredElementException2;
            boolean bl6 = false;
            bl = false;
            UndeliveredElementException it = undeliveredElementException3;
            boolean bl7 = false;
            throw it;
        }
    }

    @Override
    @NotNull
    protected String getBufferDebugString() {
        return "(buffer:capacity=" + this.capacity + ",size=" + this.size + ')';
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BufferOverflow.values().length];
            nArray[BufferOverflow.SUSPEND.ordinal()] = 1;
            nArray[BufferOverflow.DROP_LATEST.ordinal()] = 2;
            nArray[BufferOverflow.DROP_OLDEST.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

